import { Link, useLocation } from 'react-router-dom'
import { Package, Phone, Mail, MapPin } from 'lucide-react'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="app">
      <header className="header">
        <div className="container">
          <div className="header-content">
            <div className="logo">
              <Package className="logo-icon" size={36} />
            </div>
            <nav className="nav">
              <Link to="/" className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}>
                Мои аренды
              </Link>
              <Link to="/book" className={`nav-link ${location.pathname === '/book' ? 'active' : ''}`}>
                Оформить
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main">
        {children}
      </main>

      <footer className="footer">
        <div className="container">
          <div className="footer-content">
            <div className="footer-section">
              <div className="footer-logo">
                <Package className="footer-logo-icon" size={32} />
                <h2>АрендаОборудования</h2>
              </div>
              <p className="footer-description">Профессиональное оборудование для ваших мероприятий. Звук, свет, мебель - все в одном месте.</p>
            </div>
            <div className="footer-section">
              <h3 className="footer-title">Категории</h3>
              <ul className="footer-links">
                <li><a href="/book">Звуковое оборудование</a></li>
                <li><a href="/book">Освещение</a></li>
                <li><a href="/book">Мебель</a></li>
                <li><a href="/book">Сценическое оборудование</a></li>
              </ul>
            </div>
            <div className="footer-section">
              <h3 className="footer-title">Контакты</h3>
              <ul className="footer-links">
                <li>
                  <Phone className="contact-icon" size={18} />
                  <a href="tel:+79991234567">+7 (999) 123-45-67</a>
                </li>
                <li>
                  <Mail className="contact-icon" size={18} />
                  <a href="mailto:info@rental.ru">info@rental.ru</a>
                </li>
                <li>
                  <MapPin className="contact-icon" size={18} />
                  <span>Москва, ул. Примерная, 1</span>
                </li>
              </ul>
            </div>
          </div>
          <div className="footer-bottom">
            <p>&copy; 2024 АрендаОборудования. Все права защищены.</p>
          </div>
        </div>
      </footer>
    </div>
  )
}

export default Layout

